<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/', function () {
    return view('welcome');
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        $user = Auth::user(); // Obtiene el usuario autenticado
    
        if ($user->role === 'cliente') {
            // Encuentra el cliente que corresponde al user_id del usuario logueado
            $cliente = \App\Models\Client::where('user_id', $user->id)->first();
    
            if ($cliente) {
                // Redirige al detalle del cliente pasando su ID
                return redirect()->route('d-client-detail', ['id' => $cliente->id]);
            } else {
                // Si no se encuentra un cliente, redirige a una página de error o inicio
                return redirect('/')->with('error', 'No se encontró un cliente asociado.');
            }
        } elseif ($user->role === 'admin') {
            return redirect()->route('d-client-index');
        } elseif ($user->role === 'super_admin') {
            return redirect()->route('dashboard');
        }
    
        // Redirección por defecto si no coincide ningún rol
        return redirect('/');
    })->name('dashboard');

    //Client
    Route::group(['prefix'=>'client'],function(){
        Route::get('/',App\Livewire\Dashboard\Client\Index::class)->name('d-client-index');
        Route::get('/create',App\Livewire\Dashboard\Client\Save::class)->name('d-client-create');
        Route::get('/edit/{id}',App\Livewire\Dashboard\Client\Save::class)->name('d-client-edit');
        Route::get('/detail/{id}',App\Livewire\Dashboard\Client\Detail::class)->name('d-client-detail');

    });
    //Payment
    Route::group(['prefix'=>'payment'],function(){
        Route::get('/list/{id}',App\Livewire\Dashboard\Payment\Index::class)->name('d-payment-index');
        Route::get('/create',App\Livewire\Dashboard\Payment\Save::class)->name('d-payment-create');
        Route::get('/edit/{id}',App\Livewire\Dashboard\Payment\Save::class)->name('d-payment-edit');
    });
    //Payment
    Route::group(['prefix'=>'user'],function(){
        Route::get('/',App\Livewire\Dashboard\User\Index::class)->name('d-user-index');
        Route::get('/create',App\Livewire\Dashboard\User\Save::class)->name('d-user-create');
        Route::get('/edit/{id}',App\Livewire\Dashboard\User\Save::class)->name('d-user-edit');
    });
});

