<div>
    <x-action-message on="updated">
        {{ 'Pago actualizado satisfactoriamente' }}
    </x-action-message>
    <form wire:submit.prevent="submit" class="p-4 md:p-5">
        <div class="mb-4">
            <label for="name" class="block text-sm font-medium text-gray-700">Nombre</label>
            <input type="text" wire:model="name" id="name" 
                class="mt-1 block w-full rounded border-gray-300">
            @error('name')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div class="mb-4">
            <label for="email" class="block text-sm font-medium text-gray-700">Correo</label>
            <input type="email" wire:model="email" id="email" 
                class="mt-1 block w-full rounded border-gray-300">
            @error('email')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div class="mb-4">
            <label for="password" class="block text-sm font-medium text-gray-700">Contraseña</label>
            <input type="password" wire:model="password" id="password" 
                class="mt-1 block w-full rounded border-gray-300">
            @error('password')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div class="mb-4">
            <label for="password_confirmation"  class="block text-sm font-medium text-gray-700" >Confirmar Contraseña</label>
            <input type="password" class="mt-1 block w-full rounded border-gray-300" id="password_confirmation" wire:model="password_confirmation">
        </div>
        
        @if ($is_super_admin)
        <div class="mb-4">
            <label for="role" class="block text-sm font-medium text-gray-700">Tipo de pago</label>
            <select id="role" wire:model="role" class="mt-1 block w-full rounded border-gray-300">
                <option value="">Seleccione tipo de pago </option>
                <option value="super_admin">
                    Super admin
                </option>
                <option value="admin">
                    Admin
                </option>
                <option value="cliente">
                    Cliente
                </option>
            </select>
            @error('role')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div class="mb-4">
            <label for="company_id" class="block text-sm font-medium text-gray-700">Tipo de pago</label>
            <select id="company_id" wire:model="company_id" class="mt-1 block w-full rounded border-gray-300">
                <option value="">Seleccione tipo de pago </option>
                @foreach ($companies as $company)
                <option value="{{ $company->id }}">
                    {{ $company->name }}
                </option>
            @endforeach
            </select>
            @error('company_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        @endif

        <!-- Botón de Envío -->
        <x-secondary-button onclick="window.history.back()">
            Retroceder
        </x-secondary-button>
        @if ($is_super_admin)

        <x-button type="submit">
            Agregar Usuario
        </x-button>
        @else
        <x-button type="submit">
            Agregar Cliente
        </x-button>
        @endif

    </form>

</div>
