<div>
    <x-action-message on="deleted">
        {{ __('Cliente eliminado satisfactoriamente') }}
    </x-action-message>
    <x-button>
        <a href="{{ route('d-user-create') }}">
            Agregar Usuario
        </a>
    </x-button>
    <x-input wire:model.live='search'  placeholder="Buscar"></x-input>
    <div>
        <div class="bg-white shadow-md rounded my-6 overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="py-3 px-6 text-left">ID</th>
                        <th class="py-3 px-6 text-left">Nombre</th>
                        <th class="py-3 px-6 text-left">Email</th>
                        @if ($is_super_admin)
                        <th>Rol</th>
                        <th>Compañía</th>
                    @endif
                        <th class="py-3 px-6 text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody class="text-gray-700">
                    @forelse ($users as $user)
                        <tr class="border-b border-gray-200 hover:bg-gray-100">
                            <td class="py-3 px-6">{{ $user->id }}</td>
                            <td class="py-3 px-6">{{ $user->name}}</td>
                            <td class="py-3 px-6">{{ $user->email }}</td>
                            @if ($is_super_admin)
                            <td>{{ ucfirst($user->role) }}</td>
                            <td>{{ $user->company->name ?? 'Sin compañía' }}</td>
                        @endif
                            <td class="py-3 px-6 text-center">
                                <div class="flex item-center justify-center space-x-4">
                                    <x-secondary-button>
                                        <a href="{{ route('d-user-edit', $user->id) }}"
                                            class="text-blue-500 hover:underline">Editar</a>
                                    </x-secondary-button>
                                    <x-danger-button onclick="confirm('Seguro que quieres borrar el cliente?') || event.stopImmediatePropagation()" wire:click="delete({{ $user->id }})">
                                        Eliminar
                                    </x-danger-button>
                                    
                                    
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="py-3 px-6 text-center text-gray-500">No hay usuarios registrados.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            {{ $users->links() }}
        </div>
    </div>
</div>
