<div>
    <x-action-message on="updated">
        {{ 'Pago actualizado satisfactoriamente' }}
    </x-action-message>
    <form wire:submit.prevent="submit" class="p-4 md:p-5">
        <!-- Usuario -->
        <div class="mb-4">
            <label for="client_id" class="block text-sm font-medium text-gray-700">Usuario</label>
            <select id="client_id" wire:model.live="client_id" class="mt-1 block w-full rounded border-gray-300">
                <option value="">Seleccione un usuario</option>
                @foreach ($clients as $client)
                    <option value="{{ $client->id }}">
                        {{ $client->user->name }}
                    </option>
                @endforeach
            </select>
            @error('client_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <!-- Monto Pagado -->
        <div class="mb-4">
            <label for="amount_paid" class="block text-sm font-medium text-gray-700">Monto Pagado</label>
            <input type="number" wire:model="amount_paid" id="amount_paid" readonly
                class="mt-1 block w-full rounded border-gray-300 bg-gray-100 cursor-not-allowed">
            @error('amount_paid')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <!-- Fecha de Pago -->
        <div class="mb-4">
            <label for="payment_date" class="block text-sm font-medium text-gray-700">Fecha de Pago</label>
            <input type="date" wire:model="payment_date" id="payment_date" required
                class="mt-1 block w-full rounded border-gray-300">
            @error('payment_date')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <!-- Fechas Cubiertas -->
        <div class="mb-4">
            <label for="paymet_detail" class="block text-sm font-medium text-gray-700">Tipo de pago</label>
            <select id="paymet_detail" wire:model="paymet_detail" class="mt-1 block w-full rounded border-gray-300">
                <option value="">Seleccione tipo de pago </option>
                <option value="EFECTIVO">
                    Efectivo
                </option>
                <option value="YAPE">
                    Yape
                </option>
            </select>
            @error('paymet_detail')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <!-- Botón de Envío -->
        <x-secondary-button onclick="window.history.back()">
            Retroceder
        </x-secondary-button>
        <x-button type="submit">
            Agregar Pago
        </x-button>
    </form>

</div>
