<div>
    <x-action-message on="deleted">
        {{ __('Pago eliminado satisfactoriamente') }}
    </x-action-message>
    @if ($is_super_admin)
        <x-button>
            <a href="{{ route('d-payment-create') }}">
                Agregar Pago
            </a>
        </x-button>
    @endif
    <x-secondary-button onclick="window.history.back()">
        Retroceder
    </x-secondary-button>
    <x-input wire:model.live='search' placeholder="Buscar por Fecha"></x-input>
    <div>
        <div class="bg-white shadow-md rounded my-6 overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="py-3 px-6 text-left">ID</th>
                        <th class="py-3 px-6 text-left">Usuario</th>
                        <th class="py-3 px-6 text-left">Monto Pagado</th>
                        <th class="py-3 px-6 text-left">Fecha de Pago</th>
                        <th class="py-3 px-6 text-left">Tipo de pago</th>
                        @if ($is_super_admin)
                            <th class="py-3 px-6 text-center">Acciones</th>
                        @endif
                    </tr>
                </thead>
                <tbody class="text-gray-700">
                    @forelse ($payments as $payment)
                        <tr class="border-b border-gray-200 hover:bg-gray-100">
                            <td class="py-3 px-6">{{ $payment->id }}</td>
                            <td class="py-3 px-6">{{ $payment->client->user->name ?? 'Sin usuario' }}</td>
                            <td class="py-3 px-6">{{ $payment->amount_paid }}</td>
                            <td class="py-3 px-6">{{ $payment->payment_date }}</td>
                            <td class="py-3 px-6">{{ $payment->paymet_detail }}</td>
                            @if ($is_super_admin)
                                <td class="py-3 px-6 text-center">
                                    <div class="flex item-center justify-center space-x-4">
                                        <x-secondary-button>
                                            <a href="{{ route('d-payment-edit', $payment->id) }}"
                                                class="text-blue-500 hover:underline">Editar</a>
                                        </x-secondary-button>
                                        <x-danger-button
                                            onclick="confirm('Seguro que quieres borrar el cliente?') || event.stopImmediatePropagation()"
                                            wire:click="delete({{ $payment->id }})">
                                            Eliminar
                                        </x-danger-button>
                                    </div>
                                </td>
                            @endif
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="py-3 px-6 text-center text-gray-500">No hay clientes registrados.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
