<div>
    <x-action-message on="updated">
        {{ 'Cliente actualizado satisfactoriamente' }}
    </x-action-message>
    
        <form wire:submit.prevent="submit">
            <div class="mb-4">
                <label for="user_id" class="block text-sm font-medium text-gray-700">Usuario</label>
                <select id="user_id" wire:model="user_id" class="mt-1 block w-full rounded border-gray-300">
                    <option value="">Seleccione un usuario</option>
                    @foreach ($users as $user)
                        <option value="{{ $user->id }}">
                            {{ $user->name }}
                        </option>
                    @endforeach
                </select>
                @error('user_id')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div class="mb-4">
                <label for="amount_owed" class="block text-sm font-medium text-gray-700">Monto Deudado</label>
                <input wire:model="amount_owed" id="amount_owed" type="number" step="0.01"
                    class="mt-1 block w-full rounded border-gray-300">
                @error('amount_owed')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div class="mb-4">
                <label for="daily_payment" class="block text-sm font-medium text-gray-700">Pago Diario</label>
                <input wire:model="daily_payment" id="daily_payment" type="number" step="0.01"
                    class="mt-1 block w-full rounded border-gray-300">
                @error('daily_payment')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div class="mb-4">
                <label for="start_date" class="block text-sm font-medium text-gray-700">Fecha de Inicio</label>
                <input wire:model="start_date" id="start_date" type="date"
                    class="mt-1 block w-full rounded border-gray-300">
                @error('start_date')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div class="mb-4">
                <label for="end_date" class="block text-sm font-medium text-gray-700">Fecha de Inicio</label>
                <input wire:model="end_date" id="end_date" type="date"
                    class="mt-1 block w-full rounded border-gray-300">
                @error('end_date')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div class="mb-4">
                <label for="status" class="block text-sm font-medium text-gray-700">Estado</label>
                <select wire:model="status" id="status" class="mt-1 block w-full rounded border-gray-300">
                    <option value="">Seleccione</option>
                    <option value="activo">Activo</option>
                    <option value="inactivo">Inactivo</option>
                </select>
                @error('status')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>


            <x-button type="submit" class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-700">
                Guardar Cliente
            </x-button>
            <x-secondary-button onclick="window.history.back()">
                Retroceder
            </x-secondary-button>
        </form>
</div>
