<div>
    <x-action-message on="deleted">
        {{ __('Cliente eliminado satisfactoriamente') }}
    </x-action-message>
    <x-button>
        <a href="{{ route('d-client-create') }}">
            Agregar cliente
        </a>
    </x-button>
    <x-input wire:model.live='search'  placeholder="Buscar"></x-input>
    <div>
        <div class="bg-white shadow-md rounded my-6 overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="py-3 px-6 text-left">ID</th>
                        <th class="py-3 px-6 text-left">Usuario</th>
                        <th class="py-3 px-6 text-left">Deuda</th>
                        <th class="py-3 px-6 text-left">Pago Diario</th>
                        <th class="py-3 px-6 text-left">Estado</th>
                        <th class="py-3 px-6 text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody class="text-gray-700">
                    @forelse ($clients as $client)
                        <tr class="border-b border-gray-200 hover:bg-gray-100">
                            <td class="py-3 px-6">{{ $client->id }}</td>
                            <td class="py-3 px-6">{{ $client->user->name ?? 'Sin usuario' }}</td>
                            <td class="py-3 px-6">{{ $client->amount_owed }}</td>
                            <td class="py-3 px-6">{{ $client->daily_payment }}</td>
                            <td class="py-3 px-6">
                                <span
                                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                    {{ $client->status === 'activo' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ ucfirst($client->status) }}
                                </span>
                            </td>
                            <td class="py-3 px-6 text-center">
                                <div class="flex item-center justify-center space-x-4">
                                    <x-secondary-button>
                                        <a href="{{ route('d-client-edit', $client->id) }}"
                                            class="text-blue-500 hover:underline">Editar</a>
                                    </x-secondary-button>
                                    <x-danger-button onclick="confirm('Seguro que quieres borrar el cliente?') || event.stopImmediatePropagation()" wire:click="delete({{ $client->id }})">
                                        Eliminar
                                    </x-danger-button>
                                    <x-button>
                                        <a href="{{ route('d-client-detail', $client->id) }}" 
                                            >
                                            Ver Detalles
                                         </a>
                                    </x-button>
                                    
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="py-3 px-6 text-center text-gray-500">No hay clientes registrados.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            {{ $clients->links() }}
        </div>
    </div>
</div>
