<div class="container mx-auto flex flex-wrap gap-6 justify-center py-6">
    <x-action-message on="save">
        {{ 'Cliente actualizado satisfactoriamente' }}
    </x-action-message>
    <!-- Card de información del cliente -->
    <div class="w-full max-w-xs bg-white border border-gray-200 rounded-lg shadow dark:bg-gray-800 dark:border-gray-700">
        <div class="flex justify-end px-4 pt-4">
        </div>
        <div class="flex flex-col items-center pb-10">
            @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                <button
                    class="flex text-sm border-2 border-transparent rounded-full focus:outline-none focus:border-gray-300 transition">
                    <img class="w-24 h-24 mb-3 rounded-full shadow-lg" src="{{ Auth::user()->profile_photo_url }}"
                        alt="{{ Auth::user()->name }}" />
                </button>
            @else
                <span class="inline-flex rounded-md">
                    <button type="button"
                        class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none focus:bg-gray-50 active:bg-gray-50 transition ease-in-out duration-150">
                        {{ Auth::user()->name }}
                        <svg class="ms-2 -me-0.5 size-4" xmlns="http://www.w3.org/2000/svg" fill="none"
                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8.25l-7.5 7.5-7.5-7.5" />
                        </svg>
                    </button>
                </span>
            @endif

            <h5 class="mb-1 text-xl font-medium text-gray-900 dark:text-white"> {{ $client->user->name }}</h5>
            <p class="text-sm text-gray-200">{{ $client->user->email }}</p>
            <span class="text-sm text-gray-500 dark:text-gray-400">Deuda: S/{{ $client->amount_owed }}</span>
            <span class="text-sm text-gray-500 dark:text-gray-400">Pago Diario: S/{{ $client->daily_payment }}</span>
            <span class="text-sm text-gray-500 dark:text-gray-400">Fecha de Inicio: {{ $client->start_date }}</span>
            <span class="text-sm text-gray-500 dark:text-gray-400">Fecha de Termino: {{ $client->end_date }}</span>
            <span class="text-sm text-gray-500 dark:text-gray-400">Dias Pagados: {{ $dias_pagados }} De {{ $dias_por_pagar }}</span>
            <span class="text-sm text-gray-500 dark:text-gray-400">Deuda Pagada: S/{{ $deuda_pagada }} De S/{{ $client->amount_owed }}</span>



            <div class="flex mt-4 md:mt-6">
                @if ($is_super_admin)

                <button><a href="{{route('d-payment-create')}}"
                    class="py-2 px-4 ms-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700"> Agregar Pago</a>
                </button>
                @endif

                <a href="{{route('d-payment-index',$client->id)}}"
                    class="py-2 px-4 ms-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">Ver
                    Pagos</a>
            </div>


        </div>
    </div>


    <!-- Card del calendario -->
    <div
        class="w-full max-w-lg text-white bg-white border border-gray-200 rounded-lg shadow dark:bg-gray-800 dark:border-gray-700 p-4">
        <div id="calendar"></div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
    
            // Pasar los pagos y las fechas de inicio y fin como eventos
            var events = @json($client->payments->map(function($payment) {
                return [
                    'title' => 'Pago realizado',
                    'start' => $payment->payment_date,
                    'color' => 'green'
                ];
            })->toArray());
    
            // Agregar start_date (azul) y end_date (rojo)
            events.push({
                title: 'Inicio',
                start: @json($client->start_date),
                color: 'blue' // Color azul para start_date
            });
    
            events.push({
                title: 'Fin',
                start: @json($client->end_date),
                color: 'red' // Color rojo para end_date
            });
    
            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'es',
                events: events, // Cargar los eventos generados dinámicamente
                
            });
    
            calendar.render();
        });
    </script>
    
        
        
</div>
