<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Payment extends Model
{
    use HasFactory;
    protected $fillable = ['client_id', 'amount_paid', 'payment_date', 'paymet_detail'];

    public function client(): BelongsTo
    {
        return $this->belongsTo(Client::class);
    }
}
