<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Company extends Model
{
    use HasFactory;
    protected $table = 'companies';
    protected $fillable = ['name', 'address', 'owner', 'phone', 'monthly_payment', 'payment_date'];
    public function users()
    {
        return $this->hasMany(User::class);
    }
}
