<?php

namespace App\Livewire\Dashboard\Client;

use App\Models\Client;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    public $search;
    public $is_super_admin;

    protected $queryString = ['search'];

    public function mount()
    {
        // Determinar si el usuario autenticado es super_admin
        $this->is_super_admin = auth()->user()->role === 'super_admin' && auth()->user()->role === 'admin';
    }

    public function updatingSearch()
    {
        $this->resetPage(); // Resetea la paginación al buscar
    }

    public function render()
    {
        $clients = Client::query()
            ->with('user') // Carga la relación con usuarios
            ->orderBy('id', 'desc')
            ->where('status', '=', 'activo') // Solo clientes activos
            ->when(!$this->is_super_admin, function ($query) {
                // Filtrar clientes por la compañía del usuario autenticado si no es super_admin
                $companyId = auth()->user()->company_id;
                $query->whereHas('user', function ($userQuery) use ($companyId) {
                    $userQuery->where('company_id', $companyId);
                });
            });

        if ($this->search) {
            $clients->where(function ($query) {
                $query->where('id', 'like', '%' . $this->search . '%')
                    ->orWhereHas('user', function ($userQuery) {
                        $userQuery->where('name', 'like', '%' . $this->search . '%')
                            ->orWhere('email', 'like', '%' . $this->search . '%');
                    });
            });
        }

        $clients = $clients->paginate(10);

        return view('livewire.dashboard.client.index', compact('clients'))->layout('layouts.app');
    }

    public function delete(Client $client)
    {
        $client->delete();
        $this->dispatch('deleted');
    }
}
