<?php

namespace App\Livewire\Dashboard\Client;

use Carbon\Carbon;
use Livewire\Component;
use App\Models\Client;
use Illuminate\Support\Facades\Auth;

class Detail extends Component
{
    public $client;
    public $dias_pagados;
    public $dias_por_pagar;
    public $deuda_pagada;
    public $is_super_admin;


    public function mount(?int $id = null)
    {
        $this->is_super_admin = in_array(auth()->user()->role, ['super_admin', 'admin']);

        if ($id != null) {
            $this->client = Client::findOrFail($id);

            $this->dias_pagados = $this->client->payments->count('id');
            $startDate = Carbon::parse($this->client->start_date);
            $endDate = Carbon::parse($this->client->end_date);
            $this->dias_por_pagar = $startDate->diffInDays($endDate);
            $this->deuda_pagada = $this->client->payments->sum('amount_paid');

            // Solo verifica el company_id si el usuario no es super_admin
            if (Auth::user()->role !== 'super_admin' && Auth::user()->company_id !== $this->client->user->company_id) {
                session()->flash('error', 'No tienes acceso a esta página.');
                return redirect()->route('d-client-index');
            }
        }
    }

    public function render()
    {
        return view('livewire.dashboard.client.detail')->layout('layouts.app');
    }
}
